//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
namespace Exceptions
{
	class UserDefinedException : Exception 
	{
		public UserDefinedException(String s) : base(s) { }
	}
	class TestException 
	{
		public static void Main(String[] args) 
		{
			string [] s = new string [] { "divide", "null", "array", "user" };
			for (int i = 0; i < s.Length; i++) 
			{
				try 
				{
					exceptionGenerator(s[i]);
					Console.WriteLine("TestException \"" + s[i] + "\" nie zgosi wyjtku");
				} 
				catch (Exception e) 
				{
					Console.WriteLine("TestException \"" + s[i] + "\" zgosi wyjtek " + e.GetType());
					Console.WriteLine("        informujcy: " + e.Message);
				}
			}
		}
		static int exceptionGenerator(String s)
		{
			try 
			{
				if (s.Equals("divide")) 
				{
					int i = 0;
					return i/i;
				}
				if (s.Equals("null")) 
				{
					s = null;
					return s.Length;
				}
				if (s.Equals("array")) 
				{
					int [] ia = {1, 2 ,3 ,4};
					return ia[ia.Length];
				}
				if (s.Equals("user"))
					throw new UserDefinedException("UserDefinedException zgoszony przez exceptionGenerator");
				return 0;
			} 
			finally 
			{
				Console.WriteLine("[exceptionGenerator(\"" + s + "\") zakoczy prac]");
			}
		}
	}
}
